"use client"

import { ClientDataWrapper } from "@/components/client.data-wrapper"
import { ServicesTable } from "./services.table"
import { useGetStatewideServices } from "@/hooks/use-get-statewide-services"
import { LoadingTable } from "@/components/loading.table"
import { columns } from "./services.table-columns"

export function ServicesTableClient() {
  const res = useGetStatewideServices()

  return (
    <ClientDataWrapper
      swr={res}
      overrides={{
        loading: (
          <LoadingTable
            rowCount={6}
            columns={columns}
          />
        )
      }}
      content={(data) => (
        <ServicesTable data={data} />
      )}
    />
  )
}

